/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.filter;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.authz.AuthorizationService;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.PrivilegesEvaluationResult;
import com.floragunn.searchguard.authz.PrivilegesEvaluator;
import com.floragunn.searchguard.authz.SyncAuthorizationFilter;
import com.floragunn.searchguard.authz.actions.Action;
import com.floragunn.searchguard.authz.actions.ActionRequestIntrospector;
import com.floragunn.searchguard.authz.actions.Actions;
import com.floragunn.searchguard.compliance.ComplianceConfig;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.filter.ExtendedActionFilterChain;
import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContext;
import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContextProviderRegistry;
import com.floragunn.searchguard.privileges.extended_action_handling.ExtendedActionHandlingService;
import com.floragunn.searchguard.support.Base64Helper;
import com.floragunn.searchguard.support.HeaderHelper;
import com.floragunn.searchguard.support.SourceFieldsContext;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.diag.DiagnosticContext;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class SearchGuardFilter
implements ActionFilter {
    protected final Logger log = LogManager.getLogger(this.getClass());
    protected final Logger actionTrace = LogManager.getLogger((String)"sg_action_trace");
    private final PrivilegesEvaluator evalp;
    private final AdminDNs adminDns;
    private final ImmutableList<SyncAuthorizationFilter> syncAuthorizationFilters;
    private final AuditLog auditLog;
    private final org.elasticsearch.common.util.concurrent.ThreadContext threadContext;
    private final ClusterService cs;
    private final ComplianceConfig complianceConfig;
    private final SpecialPrivilegesEvaluationContextProviderRegistry specialPrivilegesEvaluationContextProviderRegistry;
    private final ExtendedActionHandlingService extendedActionHandlingService;
    private final DiagnosticContext diagnosticContext;
    private final Actions actions;
    private final ActionRequestIntrospector actionRequestIntrospector;
    private final AuthorizationService authorizationService;

    public SearchGuardFilter(AuthorizationService authorizationService, PrivilegesEvaluator evalp, AdminDNs adminDns, ImmutableList<SyncAuthorizationFilter> syncAuthorizationFilters, AuditLog auditLog, ThreadPool threadPool, ClusterService cs, DiagnosticContext diagnosticContext, ComplianceConfig complianceConfig, Actions actions, ActionRequestIntrospector actionRequestIntrospector, SpecialPrivilegesEvaluationContextProviderRegistry specialPrivilegesEvaluationContextProviderRegistry, ExtendedActionHandlingService extendedActionHandlingService, NamedXContentRegistry namedXContentRegistry) {
        this.evalp = evalp;
        this.adminDns = adminDns;
        this.syncAuthorizationFilters = syncAuthorizationFilters;
        this.auditLog = auditLog;
        this.threadContext = threadPool.getThreadContext();
        this.cs = cs;
        this.complianceConfig = complianceConfig;
        this.specialPrivilegesEvaluationContextProviderRegistry = specialPrivilegesEvaluationContextProviderRegistry;
        this.extendedActionHandlingService = extendedActionHandlingService;
        this.diagnosticContext = diagnosticContext;
        this.actions = actions;
        this.actionRequestIntrospector = actionRequestIntrospector;
        this.authorizationService = authorizationService;
    }

    public int order() {
        return Integer.MIN_VALUE;
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void apply(Task task, String action, Request request, ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
        this.specialPrivilegesEvaluationContextProviderRegistry.provide((User)this.threadContext.getTransient("_sg_user"), this.threadContext, specialPrivilegesEvaluationContext -> {
            try (ThreadContext.StoredContext ctx = this.threadContext.newStoredContext(true);){
                this.apply0(task, action, request, listener, chain, (SpecialPrivilegesEvaluationContext)specialPrivilegesEvaluationContext);
            }
            catch (Exception e) {
                this.log.error("Error in apply()", (Throwable)e);
                listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("Unexpected exception " + action, RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0])));
            }
        }, e -> {
            this.log.error("specialPrivilegesEvaluationContextProviderRegistry.provide() failed", (Throwable)e);
            listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("Unexpected exception " + action, RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0])));
        });
    }

    private <Request extends ActionRequest, Response extends ActionResponse> void apply0(Task task, String actionName, Request request, ActionListener<Response> listener, ActionFilterChain<Request, Response> chain, SpecialPrivilegesEvaluationContext specialPrivilegesEvaluationContext) {
        try {
            PrivilegesEvaluationContext privilegesEvaluationContext;
            ImmutableSet<String> mappedRoles;
            PrivilegesEvaluationResult privilegesEvaluationResult;
            if (this.threadContext.getTransient("_sg_origin") == null) {
                this.threadContext.putTransient("_sg_origin", (Object)AuditLog.Origin.LOCAL.toString());
            }
            if (this.complianceConfig != null && this.complianceConfig.isEnabled()) {
                this.attachSourceFieldContext(request);
            }
            User user = (User)this.threadContext.getTransient("_sg_user");
            boolean userIsAdmin = SearchGuardFilter.isUserAdmin(user, this.adminDns);
            boolean interClusterRequest = HeaderHelper.isInterClusterRequest(this.threadContext);
            boolean trustedClusterRequest = HeaderHelper.isTrustedClusterRequest(this.threadContext);
            boolean confRequest = "true".equals(HeaderHelper.getSafeFromHeader(this.threadContext, "_sg_conf_request"));
            boolean passThroughRequest = actionName.equals("cluster:admin/searchguard/license/info") || actionName.startsWith("indices:admin/seq_no") || actionName.equals("cluster:admin/searchguard/whoami");
            boolean internalRequest = (interClusterRequest || HeaderHelper.isDirectRequest(this.threadContext)) && actionName.startsWith("internal:") && !actionName.startsWith("internal:transport/proxy");
            this.diagnosticContext.addHeadersToLogContext(this.cs, this.threadContext);
            if (specialPrivilegesEvaluationContext != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("userIsAdmin: " + userIsAdmin + "\ninterClusterRequest: " + interClusterRequest + "\ntrustedClusterRequest: " + trustedClusterRequest + "\nconfRequest: " + confRequest + "\npassThroughRequest: " + passThroughRequest);
                    this.log.debug("Getting auth from specialPrivilegesEvaluationContext.\nOld user: " + user + "\nNew auth: " + specialPrivilegesEvaluationContext);
                    this.log.debug((Object)this.threadContext.getHeaders());
                }
                if ((user = specialPrivilegesEvaluationContext.getUser()) != null && this.threadContext.getTransient("_sg_user") == null) {
                    this.threadContext.putTransient("_sg_user", (Object)user);
                }
            }
            ThreadContext.put((String)"user", (String)(user != null ? user.getName() : "n/a"));
            if (this.actionTrace.isTraceEnabled()) {
                String count = "";
                if (request instanceof BulkRequest) {
                    count = "" + ((BulkRequest)request).requests().size();
                }
                if (request instanceof MultiGetRequest) {
                    count = "" + ((MultiGetRequest)request).getItems().size();
                }
                if (request instanceof MultiSearchRequest) {
                    count = "" + ((MultiSearchRequest)request).requests().size();
                }
                this.actionTrace.trace("Node " + this.cs.localNode().getName() + " -> " + actionName + " (" + count + "): userIsAdmin=" + userIsAdmin + "/conRequest=" + confRequest + "/internalRequest=" + internalRequest + "origin=" + this.threadContext.getTransient("_sg_origin") + "/directRequest=" + HeaderHelper.isDirectRequest(this.threadContext) + "/remoteAddress=" + request.remoteAddress());
                this.threadContext.putHeader("_sg_trace" + System.currentTimeMillis() + "#" + UUID.randomUUID().toString(), Thread.currentThread().getName() + " FILTER -> Node " + this.cs.localNode().getName() + " -> " + actionName + " userIsAdmin=" + userIsAdmin + "/conRequest=" + confRequest + "/internalRequest=" + internalRequest + "origin=" + this.threadContext.getTransient("_sg_origin") + "/directRequest=" + HeaderHelper.isDirectRequest(this.threadContext) + "/remoteAddress=" + request.remoteAddress() + " " + this.threadContext.getHeaders().entrySet().stream().filter(p -> !((String)p.getKey()).startsWith("_sg_trace")).collect(Collectors.toMap(p -> (String)p.getKey(), p -> (String)p.getValue())));
            }
            if (userIsAdmin || confRequest || internalRequest || passThroughRequest) {
                if (userIsAdmin && !confRequest && !internalRequest && !passThroughRequest) {
                    this.auditLog.logGrantedPrivileges(actionName, (TransportRequest)request, task);
                }
                chain.proceed(task, actionName, request, listener);
                return;
            }
            Action action = this.actions.get(actionName);
            if (this.complianceConfig != null && this.complianceConfig.isEnabled()) {
                Tuple<ImmutableState, ActionListener> immutableResult;
                if (request instanceof BulkShardRequest) {
                    for (BulkItemRequest bsr : ((BulkShardRequest)request).items()) {
                        immutableResult = this.checkImmutableIndices(bsr.request(), (TransportRequest)request, listener, actionName, task, this.auditLog);
                        if (immutableResult != null && immutableResult.v1() == ImmutableState.FAILURE) {
                            return;
                        }
                        if (immutableResult == null || immutableResult.v1() != ImmutableState.LISTENER) continue;
                        listener = (ActionListener)immutableResult.v2();
                    }
                } else {
                    immutableResult = this.checkImmutableIndices(request, (TransportRequest)request, listener, actionName, task, this.auditLog);
                    if (immutableResult != null && immutableResult.v1() == ImmutableState.FAILURE) {
                        return;
                    }
                    if (immutableResult != null && immutableResult.v1() == ImmutableState.LISTENER) {
                        listener = (ActionListener)immutableResult.v2();
                    }
                }
            }
            if (AuditLog.Origin.LOCAL.toString().equals(this.threadContext.getTransient("_sg_origin")) && (interClusterRequest || HeaderHelper.isDirectRequest(this.threadContext) && (specialPrivilegesEvaluationContext == null || !specialPrivilegesEvaluationContext.requiresPrivilegeEvaluationForLocalRequests()))) {
                chain.proceed(task, actionName, request, listener);
                return;
            }
            if (user == null) {
                if (actionName.startsWith("cluster:monitor/state")) {
                    chain.proceed(task, actionName, request, listener);
                    return;
                }
                this.log.error("No user found for " + actionName + " from " + request.remoteAddress() + " " + this.threadContext.getTransient("_sg_origin") + " via " + this.threadContext.getTransient("_sg_channel_type") + " " + this.threadContext.getHeaders());
                listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("No user found for " + actionName, RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
                return;
            }
            PrivilegesEvaluator eval = this.evalp;
            if (!eval.isInitialized()) {
                this.log.error("Search Guard not initialized (SG11) for {}", (Object)actionName);
                listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("Search Guard not initialized (SG11) for " + actionName + ". See https://docs.search-guard.com/latest/sgctl", RestStatus.SERVICE_UNAVAILABLE, new Object[0])));
                return;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Evaluate permissions for user: {}", (Object)user.getName());
            }
            if ((privilegesEvaluationResult = eval.evaluate(user, mappedRoles = this.authorizationService.getMappedRoles(user, specialPrivilegesEvaluationContext), actionName, request, task, privilegesEvaluationContext = new PrivilegesEvaluationContext(user, mappedRoles, action, request, eval.isDebugEnabled(), this.actionRequestIntrospector, specialPrivilegesEvaluationContext), specialPrivilegesEvaluationContext)).isOk()) {
                Action.WellKnownAction<Request, ?, ?> wellKnownAction;
                this.auditLog.logGrantedPrivileges(actionName, (TransportRequest)request, task);
                if (this.threadContext.getHeader("_sg_user_name") == null) {
                    this.threadContext.putHeader("_sg_user_name", user.getName());
                }
                for (SyncAuthorizationFilter syncAuthorizationFilter : this.syncAuthorizationFilters) {
                    SyncAuthorizationFilter.Result filterResult = syncAuthorizationFilter.apply(privilegesEvaluationContext, listener);
                    if (filterResult.getStatus() == SyncAuthorizationFilter.Result.Status.OK) continue;
                    if (filterResult.getStatus() == SyncAuthorizationFilter.Result.Status.DENIED) {
                        listener.onFailure(filterResult.toSecurityException(privilegesEvaluationContext));
                        return;
                    }
                    if (filterResult.getStatus() != SyncAuthorizationFilter.Result.Status.INTERCEPTED) continue;
                    return;
                }
                if (privilegesEvaluationResult.hasAdditionalActionFilters()) {
                    chain = new ExtendedActionFilterChain<Request, Response>((List<ActionFilter>)privilegesEvaluationResult.getAdditionalActionFilters(), chain);
                }
                if ((wellKnownAction = action.wellKnown(request)) != null && wellKnownAction.requiresSpecialProcessing()) {
                    this.extendedActionHandlingService.apply(wellKnownAction, task, actionName, privilegesEvaluationContext, request, listener, chain);
                } else {
                    chain.proceed(task, actionName, request, listener);
                }
                return;
            }
            this.auditLog.logMissingPrivileges(actionName, (TransportRequest)request, task);
            listener.onFailure(privilegesEvaluationResult.toSecurityException(privilegesEvaluationContext));
            return;
        }
        catch (Exception e) {
            this.log.error("Exception while handling " + actionName + "; " + request, (Throwable)e);
            listener.onFailure(e);
        }
        catch (Throwable e) {
            this.log.error("Throwable while handling " + actionName + "; " + request, e);
            listener.onFailure((Exception)new RuntimeException(e));
        }
    }

    private static boolean isUserAdmin(User user, AdminDNs adminDns) {
        return user != null && adminDns.isAdmin(user);
    }

    private void attachSourceFieldContext(ActionRequest request) {
        if (request instanceof SearchRequest && SourceFieldsContext.isNeeded((SearchRequest)request)) {
            if (this.threadContext.getHeader("_sg_source_field_context") == null) {
                String serializedSourceFieldContext = Base64Helper.serializeObject(new SourceFieldsContext((SearchRequest)request));
                this.threadContext.putHeader("_sg_source_field_context", serializedSourceFieldContext);
            }
        } else if (request instanceof GetRequest && SourceFieldsContext.isNeeded((GetRequest)request) && this.threadContext.getHeader("_sg_source_field_context") == null) {
            String serializedSourceFieldContext = Base64Helper.serializeObject(new SourceFieldsContext((GetRequest)request));
            this.threadContext.putHeader("_sg_source_field_context", serializedSourceFieldContext);
        }
    }

    private Tuple<ImmutableState, ActionListener> checkImmutableIndices(Object request, TransportRequest originalRequest, ActionListener originalListener, String action, Task task, AuditLog auditLog) {
        if ((request instanceof DeleteRequest || request instanceof UpdateRequest || request instanceof UpdateByQueryRequest || request instanceof DeleteByQueryRequest || request instanceof DeleteIndexRequest || request instanceof RestoreSnapshotRequest || request instanceof CloseIndexRequest || request instanceof IndicesAliasesRequest) && this.complianceConfig != null && this.complianceConfig.isIndexImmutable(action, request)) {
            auditLog.logImmutableIndexAttempt(originalRequest, action, task);
            originalListener.onFailure((Exception)((Object)new ElasticsearchSecurityException("Index is immutable", RestStatus.FORBIDDEN, new Object[0])));
            return new Tuple((Object)ImmutableState.FAILURE, (Object)originalListener);
        }
        if (request instanceof IndexRequest && this.complianceConfig != null && this.complianceConfig.isIndexImmutable(action, request)) {
            ((IndexRequest)request).opType(DocWriteRequest.OpType.CREATE);
            return new Tuple((Object)ImmutableState.LISTENER, new ImmutableIndexActionListener(originalListener, auditLog, originalRequest, action, task));
        }
        return null;
    }

    private static enum ImmutableState {
        FAILURE,
        LISTENER;

    }

    private static class ImmutableIndexActionListener<Response>
    implements ActionListener<Response> {
        private final ActionListener<Response> originalListener;
        private final AuditLog auditLog;
        private TransportRequest originalRequest;
        private String action;
        private Task task;

        public ImmutableIndexActionListener(ActionListener<Response> originalListener, AuditLog auditLog, TransportRequest originalRequest, String action, Task task) {
            this.originalListener = originalListener;
            this.auditLog = auditLog;
            this.originalRequest = originalRequest;
            this.action = action;
            this.task = task;
        }

        public void onResponse(Response response) {
            this.originalListener.onResponse(response);
        }

        public void onFailure(Exception e) {
            if (e instanceof VersionConflictEngineException) {
                this.auditLog.logImmutableIndexAttempt(this.originalRequest, this.action, this.task);
                this.originalListener.onFailure((Exception)((Object)new ElasticsearchSecurityException("Index is immutable", RestStatus.FORBIDDEN, new Object[0])));
            } else {
                this.originalListener.onFailure(e);
            }
        }
    }
}

